/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.table.writer.CsvTableWriter;
import genepi.riskscore.io.vcf.FastVCFFileReader;
import genepi.riskscore.io.vcf.MinimalVariantContext;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import picocli.CommandLine;

@CommandLine.Command(name="create-chunks", version={"1.5.1"})
public class CreateChunksCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"VCF files"})
    List<String> vcfs;
    @CommandLine.Option(names={"--size"}, description={"Chunk Size"}, required=true, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    int chunkSize = 0;
    @CommandLine.Option(names={"--out"}, description={"Output Chunk Filename)"}, required=true, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    String output = "";

    @Override
    public Integer call() throws Exception {
        CsvTableWriter writer = new CsvTableWriter(this.output);
        writer.setColumns(new String[]{"CONTIG", "START", "END", "VARIANTS", "FILENAME"});
        int countChunks = 0;
        for (String vcf : this.vcfs) {
            System.out.println("Reading file '" + vcf + "'...");
            FastVCFFileReader reader = new FastVCFFileReader(vcf);
            String contig = null;
            ConcurrentHashMap<Integer, VcfChunk> chunks = new ConcurrentHashMap<Integer, VcfChunk>();
            while (reader.next()) {
                VcfChunk chunk;
                MinimalVariantContext variant = reader.get();
                if (contig != null && !variant.getContig().equals(contig)) {
                    System.out.println("Error: Multiple contigs in file " + vcf + ". Found contigs '" + contig + "' and '" + variant.getContig() + "'");
                    return 1;
                }
                contig = variant.getContig();
                int chunkNumber = variant.getStart() / this.chunkSize;
                if (variant.getStart() % this.chunkSize == 0) {
                    --chunkNumber;
                }
                if ((chunk = (VcfChunk)chunks.get(chunkNumber)) == null) {
                    int chunkStart = chunkNumber * this.chunkSize + 1;
                    int chunkEnd = chunkStart + this.chunkSize - 1;
                    chunk = new VcfChunk(contig, chunkStart, chunkEnd);
                    chunks.put(chunkNumber, chunk);
                }
                chunk.incVariants();
            }
            reader.close();
            for (VcfChunk chunk : chunks.values()) {
                writer.setString("CONTIG", chunk.getContig());
                writer.setInteger("START", chunk.getStart());
                writer.setInteger("END", chunk.getEnd());
                writer.setInteger("VARIANTS", chunk.getVariants());
                writer.setString("FILENAME", vcf);
                writer.next();
                ++countChunks;
            }
        }
        writer.close();
        System.out.println("Done. Wrote " + countChunks + " to file '" + this.output + "'.");
        return 0;
    }

    class VcfChunk {
        private String contig;
        private int start;
        private int end;
        private int variants = 0;

        public VcfChunk(String contig, int start, int end) {
            this.contig = contig;
            this.start = start;
            this.end = end;
        }

        public String getContig() {
            return this.contig;
        }

        public void setContig(String contig) {
            this.contig = contig;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getVariants() {
            return this.variants;
        }

        public void setVariants(int variants) {
            this.variants = variants;
        }

        public void incVariants() {
            ++this.variants;
        }
    }
}

