/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.FileUtil;
import genepi.riskscore.io.meta.PGSCatalogMetaFile;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="download-meta", version={"1.5.1"})
public class DownloadMetaCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--url"}, description={"PGS-Catalog Url"}, required=false)
    String url = "https://www.pgscatalog.org/rest/score/all?format=json&limit=250";
    @CommandLine.Option(names={"--out"}, description={"Output filename"}, required=true)
    String out;

    @Override
    public Integer call() throws Exception {
        String next = this.url;
        String chunkFilename = "pgs_catalog_chunk.json";
        PGSCatalogMetaFile file = null;
        while (next != null) {
            System.out.println("Download " + next);
            InputStream in = new URL(next).openStream();
            Files.copy(in, Paths.get(chunkFilename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            PGSCatalogMetaFile file1 = PGSCatalogMetaFile.load(chunkFilename);
            if (file == null) {
                file = file1;
            } else {
                file.merge(file1);
            }
            next = file1.getNext();
        }
        file.save(this.out);
        FileUtil.deleteFile((String)chunkFilename);
        System.out.println("Downloaded meta data from PGS-Catalog to file '" + this.out + "'.");
        return 0;
    }
}

