/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.FileUtil;
import genepi.riskscore.io.PGSCatalog;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="download", version={"1.5.1"})
public class DownloadScoreCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"PGS IDs"})
    List<String> scores;
    @CommandLine.Option(names={"--out"}, description={"Output filename or folder when mutiple IDs"}, required=false)
    String out = null;

    @Override
    public Integer call() throws Exception {
        for (String score : this.scores) {
            String url = PGSCatalog.getUrl(score);
            String filename = "";
            if (this.out == null) {
                filename = score + ".txt.gz";
            } else if (this.scores.size() == 1) {
                filename = this.out;
            } else {
                FileUtil.createDirectory((String)this.out);
                filename = FileUtil.path((String[])new String[]{this.out, score + ".txt.gz"});
            }
            System.out.println("Downloading score " + score + " from " + url + "...");
            InputStream in = new URL(url).openStream();
            Files.copy(in, Paths.get(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Downloaded score from PGS-Catalog to file '" + filename + "'.");
        }
        return 0;
    }
}

