/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.FileUtil;
import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.writer.CsvTableWriter;
import genepi.io.text.GzipLineWriter;
import genepi.io.text.LineReader;
import genepi.riskscore.io.PGSCatalog;
import genepi.riskscore.io.formats.PGSCatalogFormat;
import genepi.riskscore.io.formats.RiskScoreFormatImpl;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="extract", version={"1.5.1"})
public class ExtractRegionCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--in"}, description={"input score file"}, required=true)
    private String input;
    @CommandLine.Option(names={"--out"}, description={"output score file"}, required=true)
    private String output;
    @CommandLine.Option(names={"--exclude"}, description={"exclude region (e.g. 1:1000000-5000000)"}, required=true)
    private String exclude;

    @Override
    public Integer call() throws Exception {
        System.out.println("Input File: " + this.input);
        try {
            if (!new File(this.input).exists()) {
                if (PGSCatalog.isValidId(this.input)) {
                    String id = this.input;
                    this.input = PGSCatalog.getFilenameById(id);
                } else {
                    System.out.println("*** ERROR *** File '" + this.input + "' not found.");
                    return 1;
                }
            }
            PGSCatalogFormat format = new PGSCatalogFormat(this.input, false);
            System.out.println("Input File Format: " + format);
            Region region = new Region(this.exclude);
            System.out.println(region);
            CsvTableReader reader = new CsvTableReader(this.input, format.getSeparator());
            CsvTableWriter writer = new CsvTableWriter(this.output + ".raw", format.getSeparator(), false);
            writer.setColumns(reader.getColumns());
            int ignored = 0;
            int row = 0;
            int excluded = 0;
            int remaing = 0;
            while (reader.next()) {
                ++row;
                boolean ignore = false;
                String chromosome = reader.getString(((RiskScoreFormatImpl)format).getChromosome());
                if (reader.getString(((RiskScoreFormatImpl)format).getPosition()).isEmpty()) {
                    this.log("Warning: Row " + row + ": Position is empty. Ignore variant.");
                    ++ignored;
                    ignore = true;
                }
                int position = 0;
                if (!ignore) {
                    try {
                        position = reader.getInteger(((RiskScoreFormatImpl)format).getPosition());
                    }
                    catch (NumberFormatException e) {
                        this.log("Warning: Row " + row + ": '" + reader.getString(((RiskScoreFormatImpl)format).getPosition()) + "' is an invalid position. Ignore variant.");
                        ++ignored;
                        ignore = true;
                    }
                }
                String id = chromosome + ":" + position;
                if (ignore) continue;
                if (!region.contains(chromosome, position)) {
                    ++remaing;
                    writer.setRow(reader.getRow());
                    writer.next();
                    continue;
                }
                ++excluded;
                this.log("Excluded variant '" + id + "'");
            }
            reader.close();
            writer.close();
            this.compress(this.output + ".raw", this.output);
            System.out.println("Variants read: " + row);
            System.out.println("Variants ignored: " + ignored);
            System.out.println("Variants excluded: " + excluded);
            System.out.println("Variants remaining: " + remaing);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*** ERROR ***  " + e);
            new File(this.output).delete();
            return 1;
        }
    }

    protected void log(String message) {
        System.out.println(message);
    }

    private void compress(String input, String output) throws IOException {
        LineReader reader = new LineReader(input);
        GzipLineWriter writer = new GzipLineWriter(output);
        while (reader.next()) {
            writer.write(reader.get());
        }
        writer.close();
        reader.close();
        FileUtil.deleteFile((String)input);
    }

    class Region {
        private String chromosome = "?";
        private int start = 0;
        private int end = 0;

        public Region(String region) {
            String[] tiles = region.split(":");
            this.chromosome = tiles[0];
            String[] tiles2 = tiles[1].split("-");
            this.start = Integer.parseInt(tiles2[0]);
            this.end = Integer.parseInt(tiles2[1]);
        }

        public String getChromosome() {
            return this.chromosome;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }

        public boolean contains(String chormosome, int position) {
            if (this.chromosome.equals(chormosome)) {
                return position >= this.start && position <= this.end;
            }
            return false;
        }

        public String toString() {
            return "Chromosome: " + this.chromosome + ", Start: " + this.start + ", End; " + this.end;
        }
    }
}

