/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.FileUtil;
import genepi.io.text.GzipLineWriter;
import genepi.io.text.LineReader;
import genepi.riskscore.tasks.LiftOverScoreTask;
import java.util.List;
import java.util.concurrent.Callable;
import lukfor.progress.TaskService;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.Task;
import picocli.CommandLine;

@CommandLine.Command(name="liftover", version={"1.5.1"})
public class LiftOverScoreCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--in"}, description={"input score file"}, required=true)
    private String input;
    @CommandLine.Option(names={"--out"}, description={"output score file"}, required=true)
    private String output;
    @CommandLine.Option(names={"--chain"}, description={"chain file"}, required=true)
    private String chain;

    @Override
    public Integer call() throws Exception {
        LiftOverScoreTask.VERBOSE = true;
        LiftOverScoreTask task = new LiftOverScoreTask(this.input, this.output + ".raw", this.chain);
        TaskService.setAnsiSupport((boolean)false);
        TaskService.setAnimated((boolean)false);
        List result = TaskService.run((ITaskRunnable[])new ITaskRunnable[]{task});
        if (!((Task)result.get(0)).getStatus().isSuccess()) {
            ((Task)result.get(0)).getStatus().getThrowable().printStackTrace();
            System.out.println("*** ERROR ***  " + ((Task)result.get(0)).getStatus().getThrowable());
            return 1;
        }
        System.out.println("Number Variants Input: " + task.getTotal());
        System.out.println("Number Variants lifted: " + task.getResolved());
        System.out.println("Ignored Variants: " + task.getFailed());
        LineReader reader = new LineReader(this.output + ".raw");
        GzipLineWriter writer = new GzipLineWriter(this.output);
        while (reader.next()) {
            writer.write(reader.get());
        }
        writer.close();
        reader.close();
        FileUtil.deleteFile((String)(this.output + ".raw"));
        return 0;
    }
}

