/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.text.LineReader;
import genepi.io.text.LineWriter;
import genepi.riskscore.App;
import genepi.riskscore.io.dbsnp.DbSnpReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import lukfor.progress.TaskService;
import lukfor.progress.renderer.IProgressIndicator;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;
import lukfor.progress.util.CountingInputStream;
import picocli.CommandLine;

@CommandLine.Command(name="proxy", version={"1.5.1"})
public class ProcessHaploRegCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--in"}, description={"Input filename"}, required=true)
    String input;
    @CommandLine.Option(names={"--out"}, description={"Output filename"}, required=true)
    String output;
    @CommandLine.Option(names={"--r2"}, description={"LD threshold"}, required=false)
    double r2 = 0.95;
    @CommandLine.Option(names={"--dbsnp"}, description={"dbsnp index"}, required=true)
    String dbsnp = "";
    @CommandLine.Option(names={"--no-ansi"}, description={"Disable ANSI output"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean noAnsi = false;
    @CommandLine.Option(names={"--ids"}, description={"rsIds of snps used in index"}, required=false)
    String ids = null;

    @Override
    public Integer call() throws Exception {
        if (this.noAnsi) {
            TaskService.setAnimated((boolean)false);
            TaskService.setAnsiColors((boolean)false);
        }
        ProcessHaploRegTask task = new ProcessHaploRegTask();
        TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_LONG_TASK}).run(new ITaskRunnable[]{task});
        return 0;
    }

    public static String join(List<String> alleles) {
        String result = "";
        for (int i = 0; i < alleles.size(); ++i) {
            if (i > 0) {
                result = result + ";";
            }
            result = result + alleles.get(i);
        }
        return result;
    }

    class ProcessHaploRegTask
    implements ITaskRunnable {
        ProcessHaploRegTask() {
        }

        public void run(ITaskMonitor monitor) throws Exception {
            monitor.begin("Parse file", new File(ProcessHaploRegCommand.this.input).length());
            CountingInputStream countingStream = new CountingInputStream((InputStream)new FileInputStream(ProcessHaploRegCommand.this.input), monitor);
            DbSnpReader dbSnpReader = new DbSnpReader(ProcessHaploRegCommand.this.dbsnp);
            LineWriter writer = new LineWriter(ProcessHaploRegCommand.this.output);
            LineReader reader = new LineReader(new DataInputStream((InputStream)countingStream));
            HashSet<String> rsIds = new HashSet<String>();
            if (ProcessHaploRegCommand.this.ids != null) {
                LineReader rsIdsReader = new LineReader(ProcessHaploRegCommand.this.ids);
                while (rsIdsReader.next()) {
                    String id = rsIdsReader.get();
                    if (id.trim().isEmpty()) continue;
                    rsIds.add(id.trim());
                }
                rsIdsReader.close();
            }
            while (reader.next()) {
                String[] proxies;
                DbSnpReader.Snp snp;
                if (monitor.isCanceled()) {
                    writer.close();
                    reader.close();
                    return;
                }
                Vector<String> finalProxies = new Vector<String>();
                String line = reader.get();
                String[] tiles = line.split("\t");
                String id = tiles[0];
                if (!rsIds.isEmpty() && !rsIds.contains(id) || (snp = dbSnpReader.getByRsId(id)) == null || snp.getAlternate().contains(",")) continue;
                for (String proxy : proxies = tiles[1].split(";")) {
                    DbSnpReader.Snp proxySnp;
                    String[] proxyDetails = proxy.split(",");
                    double proxyR2 = Double.parseDouble(proxyDetails[1]);
                    if (!(proxyR2 >= ProcessHaploRegCommand.this.r2) || (proxySnp = dbSnpReader.getByRsId(proxyDetails[0])) == null || proxySnp.getAlternate().contains(",")) continue;
                    finalProxies.add(proxySnp.getChromosome() + ":" + proxySnp.getPosition() + ":" + proxySnp.getReference() + ":" + proxySnp.getAlternate());
                }
                if (finalProxies.isEmpty()) continue;
                writer.write(snp.getChromosome() + "\t" + snp.getPosition() + "\t" + snp.getReference() + "\t" + snp.getAlternate() + "\t" + ProcessHaploRegCommand.join(finalProxies));
            }
            reader.close();
            writer.close();
        }
    }
}

