/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.FileUtil;
import genepi.io.text.GzipLineWriter;
import genepi.io.text.LineReader;
import genepi.riskscore.io.PGSCatalog;
import genepi.riskscore.io.RiskScoreFile;
import genepi.riskscore.io.formats.RiskScoreFormatFactory;
import genepi.riskscore.io.formats.RiskScoreFormatImpl;
import genepi.riskscore.tasks.ApplyScoreTask;
import genepi.riskscore.tasks.LiftOverScoreTask;
import genepi.riskscore.tasks.ResolveScoreTask;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import lukfor.progress.TaskService;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.Task;
import picocli.CommandLine;

@CommandLine.Command(name="resolve", version={"1.5.1"})
public class ResolveScoreCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--in"}, description={"input score file"}, required=true)
    private String input;
    @CommandLine.Option(names={"--out"}, description={"output score file"}, required=true)
    private String output;
    @CommandLine.Option(names={"--dbsnp"}, description={"dbsnp index file"}, required=true)
    private String dbsnp;
    @CommandLine.Option(names={"--chain"}, description={"dbsnp index file"}, required=false)
    private String chain;
    @CommandLine.Option(names={"--force-rsids"}, description={"Resolve rsIds also when chromosomal positions are available"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean forceRsIds = false;
    @CommandLine.Option(names={"--verbose"}, description={"Show debug messages"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean verbose = false;

    @Override
    public Integer call() throws Exception {
        if (this.verbose) {
            RiskScoreFile.VERBOSE = true;
            ResolveScoreTask.VERBOSE = true;
            ApplyScoreTask.VERBOSE = true;
            LiftOverScoreTask.VERBOSE = true;
            PGSCatalog.VERBOSE = true;
        }
        long start = System.currentTimeMillis();
        System.out.println("Input File: " + this.input);
        try {
            List result;
            Object task;
            if (!new File(this.input).exists()) {
                if (PGSCatalog.isValidId(this.input)) {
                    String id = this.input;
                    this.input = PGSCatalog.getFilenameById(id);
                } else {
                    System.out.println("*** ERROR *** File '" + this.input + "' not found.");
                    return 1;
                }
            }
            RiskScoreFormatImpl format = RiskScoreFormatFactory.buildFormat(this.input, RiskScoreFormatFactory.RiskScoreFormat.AUTO_DETECT);
            System.out.println("Input File Format: " + format);
            System.out.println("--------------------------------------");
            if (format.hasRsIds() || this.forceRsIds) {
                System.out.println("Resolve rsIDs using index file '" + this.dbsnp + "'...");
                task = new ResolveScoreTask(this.input, this.output + ".raw", this.dbsnp);
                TaskService.setAnsiSupport((boolean)false);
                TaskService.setAnimated((boolean)false);
                result = TaskService.run((ITaskRunnable[])new ITaskRunnable[]{task});
                if (!((Task)result.get(0)).getStatus().isSuccess()) {
                    ((Task)result.get(0)).getStatus().getThrowable().printStackTrace();
                    System.out.println("*** ERROR ***  " + ((Task)result.get(0)).getStatus().getThrowable());
                    return 1;
                }
                System.out.println("Number Variants Input: " + ((ResolveScoreTask)task).getTotal());
                System.out.println("Number Variants Resolved: " + ((ResolveScoreTask)task).getResolved());
                System.out.println("  Other Allele: ");
                System.out.println("    Reference Allele dbSNP: " + ((ResolveScoreTask)task).getOtherAlleleReference());
                System.out.println("    Alternate Allele dbSNP: " + ((ResolveScoreTask)task).getOtherAlleleAlternate());
                System.out.println("    From Source File: " + ((ResolveScoreTask)task).getOtherAlleleSource());
                System.out.println("Ignored Variants: ");
                System.out.println("  Not found in dbSNP: " + ((ResolveScoreTask)task).getIgnoredNotInDbSnp());
                System.out.println("  Multiple Alternate Alleles: " + ((ResolveScoreTask)task).getIgnoredMulAlternateAlleles());
                this.compress(this.output + ".raw", this.output);
            } else if (this.chain != null) {
                System.out.println("Liftover using chain file '" + this.chain + "'...");
                task = new LiftOverScoreTask(this.input, this.output + ".raw", this.chain);
                TaskService.setAnsiSupport((boolean)false);
                TaskService.setAnimated((boolean)false);
                result = TaskService.run((ITaskRunnable[])new ITaskRunnable[]{task});
                if (!((Task)result.get(0)).getStatus().isSuccess()) {
                    ((Task)result.get(0)).getStatus().getThrowable().printStackTrace();
                    System.out.println("*** ERROR ***  " + ((Task)result.get(0)).getStatus().getThrowable());
                    return 1;
                }
                System.out.println("Number Variants Input: " + ((LiftOverScoreTask)task).getTotal());
                System.out.println("Number Variants lifted: " + ((LiftOverScoreTask)task).getResolved());
                System.out.println("Number Variants not lifted: " + ((LiftOverScoreTask)task).getFailed());
                System.out.println("Ignored Variants (no position): " + ((LiftOverScoreTask)task).getIgnored());
                this.compress(this.output + ".raw", this.output);
            } else {
                FileUtil.copy((String)this.input, (String)this.output);
            }
            System.out.println("--------------------------------------");
            RiskScoreFile score = null;
            int loaded = 0;
            for (int i = 1; i <= 22; ++i) {
                System.out.println("Validate chromosome " + i + "...");
                score = new RiskScoreFile(this.output, this.dbsnp, null);
                score.buildIndex(i + "");
                loaded += score.getLoadedVariants();
            }
            System.out.println("Validate chromosome X...");
            score = new RiskScoreFile(this.output, this.dbsnp, null);
            score.buildIndex("X");
            long end = System.currentTimeMillis();
            System.out.println("--------------------------------------");
            System.out.println("Output File: " + this.output);
            System.out.println("Output File Format: " + score.getFormat());
            System.out.println("Number Variants Output: " + (loaded += score.getLoadedVariants()) + "/" + score.getTotalVariants());
            System.out.println("--------------------------------------");
            System.out.println("Execution Time: " + (end - start) / 1000L + " sec");
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*** ERROR ***  " + e);
            new File(this.output).delete();
            return 1;
        }
    }

    private void compress(String input, String output) throws IOException {
        LineReader reader = new LineReader(input);
        GzipLineWriter writer = new GzipLineWriter(output);
        while (reader.next()) {
            writer.write(reader.get());
        }
        writer.close();
        reader.close();
        FileUtil.deleteFile((String)input);
    }
}

