/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.table.writer.CsvTableWriter;
import genepi.riskscore.io.PGSCatalog;
import genepi.riskscore.io.RiskScoreFile;
import genepi.riskscore.tasks.ApplyScoreTask;
import genepi.riskscore.tasks.LiftOverScoreTask;
import genepi.riskscore.tasks.ResolveScoreTask;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="validate", version={"1.5.1"})
public class ValidateScoreCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"Score files"})
    List<String> scores;
    @CommandLine.Option(names={"--out"}, description={"Output filename"}, required=false)
    String out;
    @CommandLine.Option(names={"--verbose"}, description={"Show debug messages"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean verbose = false;

    @Override
    public Integer call() throws Exception {
        if (this.verbose) {
            RiskScoreFile.VERBOSE = true;
            ResolveScoreTask.VERBOSE = true;
            ApplyScoreTask.VERBOSE = true;
            LiftOverScoreTask.VERBOSE = true;
            PGSCatalog.VERBOSE = true;
        }
        CsvTableWriter writer = null;
        if (this.out != null) {
            writer = new CsvTableWriter(this.out);
            writer.setColumns(new String[]{"score", "coverage", "variants", "original_variants"});
        }
        for (String input : this.scores) {
            try {
                RiskScoreFile score = null;
                int loaded = 0;
                for (int i = 1; i <= 22; ++i) {
                    System.out.println("Validate chromosome " + i + "...");
                    score = new RiskScoreFile(input, null, null);
                    score.buildIndex(i + "");
                    loaded += score.getLoadedVariants();
                }
                System.out.println("Validate chromosome X...");
                score = new RiskScoreFile(input, null, null);
                score.buildIndex("X");
                loaded += score.getLoadedVariants();
                String name = RiskScoreFile.getName(input);
                System.out.println("--------------------------------------");
                System.out.println("Score File: " + input);
                System.out.println("Score Name: " + name);
                System.out.println("Output File Format: " + score.getFormat());
                System.out.println("Number Variants Output: " + loaded + "/" + score.getTotalVariants());
                System.out.println("--------------------------------------");
                if (writer == null) continue;
                writer.setString("score", name);
                writer.setDouble("coverage", (double)loaded / (double)score.getTotalVariants());
                writer.setInteger("variants", loaded);
                writer.setInteger("original_variants", score.getTotalVariants());
                writer.next();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("*** ERROR ***  " + e);
                return 1;
            }
        }
        if (writer != null) {
            writer.close();
        }
        return 0;
    }
}

