/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import genepi.io.text.LineWriter;
import genepi.riskscore.io.meta.JsonMetaFileReader;
import genepi.riskscore.io.meta.TabMetaFileReader;
import genepi.riskscore.model.ScorePopulationMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class MetaFile {
    protected Map<String, MetaScore> index;

    public MetaFile(Map<String, MetaScore> index) {
        this.index = index;
    }

    public static MetaFile load(String filename) throws JsonIOException, JsonSyntaxException, IOException {
        if (filename.endsWith(".json")) {
            return JsonMetaFileReader.load(filename);
        }
        if (filename.endsWith(".csv") || filename.endsWith(".txt") || filename.endsWith("tab")) {
            return TabMetaFileReader.load(filename);
        }
        throw new IOException("Unsupported file format");
    }

    public MetaScore getById(String id) {
        return this.index.get(id);
    }

    public void save(String filename) throws IOException {
        Gson gson = new Gson();
        String json = gson.toJson(this.index);
        LineWriter writer = new LineWriter(filename);
        writer.write(json);
        writer.close();
    }

    public static class MetaScore {
        private String id;
        private String trait;
        private List<Map<String, String>> efo;
        private String traitAdditional;
        private ScorePopulationMap populations;
        private Map<String, String> publication;
        private int variants;
        private String repository;
        private String link;
        private int samples;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTrait() {
            return this.trait;
        }

        public void setTrait(String trait) {
            this.trait = trait;
        }

        public String getTraitAdditional() {
            return this.traitAdditional;
        }

        public void setTraitAdditional(String traitAdditional) {
            this.traitAdditional = traitAdditional;
        }

        public List<Map<String, String>> getEfo() {
            return this.efo;
        }

        public void setEfo(List<Map<String, String>> efo) {
            this.efo = efo;
        }

        public ScorePopulationMap getPopulations() {
            return this.populations;
        }

        public void setPopulations(ScorePopulationMap populations) {
            this.populations = populations;
        }

        public Map<String, String> getPublication() {
            return this.publication;
        }

        public void setPublication(Map<String, String> publication) {
            this.publication = publication;
        }

        public int getVariants() {
            return this.variants;
        }

        public void setVariants(int variants) {
            this.variants = variants;
        }

        public String getRepository() {
            return this.repository;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public int getSamples() {
            return this.samples;
        }

        public void setSamples(int samples) {
            this.samples = samples;
        }
    }
}

