/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.riskscore.io.OutputFileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class OutputFile {
    private List<String> samples;
    private List<double[]> data;
    private List<String> scores;

    public OutputFile(String filename) throws IOException {
        OutputFileReader outputFile = new OutputFileReader(filename);
        this.scores = outputFile.getScores();
        this.samples = new Vector<String>();
        this.data = new Vector<double[]>();
        while (outputFile.next()) {
            this.samples.add(outputFile.getSample());
            double[] values = Arrays.copyOf(outputFile.getValues(), outputFile.getValues().length);
            this.data.add(values);
        }
        outputFile.close();
    }

    public int getCountSamples() {
        return this.samples.size();
    }

    public List<String> getSamples() {
        return this.samples;
    }

    public int getCountScores() {
        return this.scores.size();
    }

    public List<String> getScores() {
        return this.scores;
    }

    public double getValue(int score, int sample) {
        return this.data.get(sample)[score];
    }

    public double[] getValuesByScore(int score) {
        double[] values = new double[this.samples.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getValue(score, i);
        }
        return values;
    }
}

