/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.reader.ITableReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class OutputFileReader {
    public static final String COLUMN_SAMPLE = "sample";
    public static final char SEPARATOR = ',';
    private double[] data;
    private List<String> scores;
    private ITableReader reader;

    public OutputFileReader(String filename) {
        this.init(filename);
    }

    public void init(String filename) {
        String[] columns;
        this.reader = new CsvTableReader(filename, ',');
        this.scores = new Vector<String>();
        for (String column : columns = this.reader.getColumns()) {
            if (column.equals(COLUMN_SAMPLE)) continue;
            this.scores.add(column);
        }
        this.data = new double[this.scores.size()];
    }

    public boolean next() {
        return this.reader.next();
    }

    public double[] getValues() {
        for (int i = 0; i < this.scores.size(); ++i) {
            this.data[i] = this.reader.getDouble(this.scores.get(i));
        }
        return this.data;
    }

    public String getSample() throws IOException {
        return this.reader.getString(COLUMN_SAMPLE);
    }

    public void close() {
        this.reader.close();
    }

    public List<String> getScores() {
        return this.scores;
    }

    public String toString() {
        return "scores: " + this.scores.size();
    }
}

