/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.table.writer.CsvTableWriter;
import genepi.riskscore.model.RiskScore;
import genepi.riskscore.model.RiskScoreSummary;
import java.util.List;
import java.util.Vector;

public class OutputFileWriter {
    public static final String COLUMN_SAMPLE = "sample";
    public static final char SEPARATOR = ',';
    private List<String> samples;
    private List<Double>[] data;
    private List<String> scores;

    public OutputFileWriter() {
    }

    public OutputFileWriter(List<RiskScore> finalScores, RiskScoreSummary[] summaries) {
        this.scores = new Vector<String>();
        for (RiskScoreSummary summary : summaries) {
            this.scores.add(summary.getName());
        }
        this.samples = new Vector<String>();
        this.data = new Vector[this.scores.size()];
        for (int i = 0; i < this.scores.size(); ++i) {
            this.data[i] = new Vector<Double>();
        }
        for (RiskScore riskScore : finalScores) {
            this.samples.add(riskScore.getSample());
            for (int i = 0; i < this.scores.size(); ++i) {
                this.data[i].add(riskScore.getScore(i));
            }
        }
    }

    public void save(String filename) {
        String[] columns = new String[this.scores.size() + 1];
        columns[0] = COLUMN_SAMPLE;
        for (int i = 0; i < this.scores.size(); ++i) {
            columns[i + 1] = this.scores.get(i);
        }
        CsvTableWriter writer = new CsvTableWriter(filename, ',');
        writer.setColumns(columns);
        for (int i = 0; i < this.samples.size(); ++i) {
            writer.setString(COLUMN_SAMPLE, this.samples.get(i));
            for (int j = 0; j < this.scores.size(); ++j) {
                writer.setDouble(this.scores.get(j), this.data[j].get(i).doubleValue());
            }
            writer.next();
        }
        writer.close();
    }
}

