/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;

public class PGSCatalog {
    public static String USER_HOME = System.getProperty("user.home");
    public static boolean ENABLE_CACHE = true;
    public static String CACHE_DIR = FileUtil.path((String[])new String[]{USER_HOME, ".pgs-calc", "pgs-catalog"});
    public static String FILE_URL = "http://ftp.ebi.ac.uk/pub/databases/spot/pgs/scores/{0}/ScoringFiles/{0}.txt.gz";
    public static boolean VERBOSE = false;

    public static String getFilenameById(String id) throws IOException {
        String filename = FileUtil.path((String[])new String[]{CACHE_DIR, id + ".txt.gz"});
        if (new File(filename).exists()) {
            PGSCatalog.debug("Score '" + id + "' found in local cache " + filename);
            if (ENABLE_CACHE) {
                return filename;
            }
            new File(filename).delete();
        }
        FileUtil.createDirectory((String)CACHE_DIR);
        String url = PGSCatalog.getUrl(id);
        PGSCatalog.debug("Downloading score '" + id + "' from " + url + "...");
        InputStream in = new URL(url).openStream();
        Files.copy(in, Paths.get(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        PGSCatalog.debug("Score '" + id + "' downloaded and cached in file '" + filename + "'.");
        return filename;
    }

    public static void clearCache() {
        FileUtil.deleteDirectory((String)CACHE_DIR);
        PGSCatalog.debug("Deleted cache directory '" + CACHE_DIR + "'");
    }

    public static boolean isValidId(String id) {
        return id.startsWith("PGS") && id.length() == 9 && !id.endsWith(".txt.gz");
    }

    public static String getUrl(String id) {
        MessageFormat format = new MessageFormat(FILE_URL);
        return format.format(new Object[]{id});
    }

    public static void debug(String message) {
        if (VERBOSE) {
            System.out.println(message);
        }
    }
}

