/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.text.LineReader;
import java.io.File;
import java.util.Vector;

public class PGSCatalogIDFile {
    private String filename;
    public static final String COLUMN_ID = "PGSID";

    public PGSCatalogIDFile(String filename) {
        this.filename = filename;
    }

    public String[] getIds() throws Exception {
        if (!new File(this.filename).exists()) {
            throw new Exception("File '" + this.filename + "' not found.");
        }
        LineReader reader = new LineReader(this.filename);
        if (!reader.next()) {
            throw new Exception("File '" + this.filename + "' is empty.");
        }
        String header = reader.get();
        if (!header.equalsIgnoreCase(COLUMN_ID)) {
            throw new Exception("Column 'PGSID' not found in '" + this.filename + "'");
        }
        Vector<String> ids = new Vector<String>();
        while (reader.next()) {
            String id = reader.get();
            if (id.trim().isEmpty() || ids.contains(id)) continue;
            ids.add(id);
        }
        reader.close();
        String[] result = new String[ids.size()];
        return ids.toArray(result);
    }
}

