/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.reflect.TypeToken;
import genepi.riskscore.io.MetaFile;
import genepi.riskscore.model.RiskScoreSummary;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Vector;

public class ReportFile {
    private List<RiskScoreSummary> summaries = new Vector<RiskScoreSummary>();

    public ReportFile() {
    }

    public ReportFile(RiskScoreSummary[] summaries) {
        for (RiskScoreSummary summary : summaries) {
            this.summaries.add(summary);
        }
    }

    public void save(String filename) throws JsonIOException, IOException {
        Gson gson = new Gson();
        Type type = new TypeToken<List<RiskScoreSummary>>(){}.getType();
        FileWriter writer = new FileWriter(filename);
        gson.toJson(this.summaries, type, (Appendable)writer);
        writer.close();
    }

    public static ReportFile loadFromFile(String filename) throws IOException {
        ReportFile reportFile = new ReportFile();
        reportFile.load(filename);
        return reportFile;
    }

    public void load(String filename) throws IOException {
        Gson gson = new Gson();
        Type type = new TypeToken<List<RiskScoreSummary>>(){}.getType();
        this.summaries = (List)gson.fromJson((Reader)new FileReader(filename), type);
    }

    public void merge(ReportFile file) throws Exception {
        this.summaries.size();
        file.summaries.size();
        if (this.summaries.size() != file.summaries.size()) {
            throw new Exception("Different number of scores. Expected " + this.summaries.size() + " samples but found " + file.summaries.size() + " scores.");
        }
        for (int i = 0; i < this.summaries.size(); ++i) {
            this.summaries.get(i).merge(file.summaries.get(i));
        }
    }

    public void mergeWithMeta(MetaFile meta) {
        for (RiskScoreSummary summary : this.summaries) {
            MetaFile.MetaScore data = meta.getById(summary.getName());
            if (data == null) continue;
            summary.setMeta(data);
        }
    }

    public List<RiskScoreSummary> getSummaries() {
        return this.summaries;
    }

    public String toString() {
        return "scores: " + this.summaries.size();
    }
}

