/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.FileUtil;
import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.reader.ITableReader;
import genepi.riskscore.io.Chunk;
import genepi.riskscore.io.PGSCatalog;
import genepi.riskscore.io.formats.RiskScoreFormatFactory;
import genepi.riskscore.io.formats.RiskScoreFormatImpl;
import genepi.riskscore.io.proxy.ProxyReader;
import genepi.riskscore.model.ReferenceVariant;
import genepi.riskscore.tasks.ResolveScoreTask;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lukfor.progress.TaskService;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.Task;

public class RiskScoreFile {
    private String filename;
    private Map<Integer, ReferenceVariant> variants;
    private String proxies;
    private int totalVariants = 0;
    private int ignoredVariants = 0;
    private int loadedVariants = 0;
    private int loadedProxies = 0;
    private RiskScoreFormatImpl format;
    public static boolean VERBOSE = false;

    public RiskScoreFile(String filename, String dbsnp, String proxyFile) throws Exception {
        this(filename, RiskScoreFormatFactory.RiskScoreFormat.AUTO_DETECT, dbsnp, proxyFile);
    }

    public RiskScoreFile(String filename, RiskScoreFormatFactory.RiskScoreFormat format, String dbsnp, String proxies) throws Exception {
        this.filename = filename;
        this.variants = new HashMap<Integer, ReferenceVariant>();
        if (!new File(filename).exists()) {
            if (PGSCatalog.isValidId(filename)) {
                String id = filename;
                this.filename = PGSCatalog.getFilenameById(id);
            } else {
                throw new Exception("File '" + filename + "' not found.");
            }
        }
        this.format = RiskScoreFormatFactory.buildFormat(this.filename, format);
        if (this.format.hasRsIds()) {
            if (dbsnp == null) {
                throw new IOException("File " + this.filename + " is in RS_ID format. Please specify dbsnp index.");
            }
            String originalFilename = this.filename;
            this.filename = originalFilename + ".positions";
            ResolveScoreTask convertRsIds = new ResolveScoreTask(originalFilename, this.filename, dbsnp);
            TaskService.setAnsiSupport((boolean)false);
            TaskService.setAnimated((boolean)false);
            List result = TaskService.run((ITaskRunnable[])new ITaskRunnable[]{convertRsIds});
            if (!((Task)result.get(0)).getStatus().isSuccess()) {
                throw new IOException(((Task)result.get(0)).getStatus().getThrowable());
            }
        }
        this.proxies = proxies;
        DataInputStream in = this.openTxtOrGzipStream(this.filename);
        CsvTableReader reader = new CsvTableReader(in, this.format.getSeparator());
        this.checkFileFormat((ITableReader)reader, this.filename);
        reader.close();
    }

    private void checkFileFormat(ITableReader reader, String filename) throws Exception {
        if (!reader.hasColumn(this.format.getChromosome())) {
            throw new Exception("Column '" + this.format.getChromosome() + "' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(this.format.getPosition())) {
            throw new Exception("Column '" + this.format.getPosition() + "' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(this.format.getEffectWeight())) {
            throw new Exception("Column '" + this.format.getEffectWeight() + "' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(this.format.getOtherAllele())) {
            throw new Exception("Column '" + this.format.getOtherAllele() + "' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(this.format.getEffectAllele())) {
            throw new Exception("Column '" + this.format.getEffectAllele() + "' not found in '" + filename + "'");
        }
    }

    public void buildIndex(String chromosome) throws IOException {
        this.buildIndex(chromosome, new Chunk());
    }

    public void buildIndex(String chromosome, Chunk chunk) throws IOException {
        assert (chromosome != null);
        ProxyReader proxyReader = null;
        if (this.proxies != null) {
            proxyReader = new ProxyReader(this.proxies);
        }
        try {
            DataInputStream in = this.openTxtOrGzipStream(this.filename);
            CsvTableReader reader = new CsvTableReader(in, this.format.getSeparator());
            while (reader.next()) {
                ProxyReader.ProxySnp[] proxySnps;
                int row = ++this.totalVariants;
                String chromsomeVariant = reader.getString(this.format.getChromosome());
                if (!chromsomeVariant.equals(chromosome)) continue;
                if (reader.getString(this.format.getPosition()).isEmpty()) {
                    this.warning("Row " + row + ": Position is empty. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                int position = 0;
                try {
                    position = reader.getInteger(this.format.getPosition());
                }
                catch (NumberFormatException e) {
                    this.warning("Row " + row + ": '" + reader.getString(this.format.getPosition()) + "' is an invalid position. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                if (position < chunk.getStart() || position > chunk.getEnd()) continue;
                float effectWeight = 0.0f;
                try {
                    effectWeight = Double.valueOf(reader.getDouble(this.format.getEffectWeight())).floatValue();
                }
                catch (NumberFormatException e) {
                    this.warning("Row " + row + ": '" + reader.getString(this.format.getEffectWeight()) + "' is an invalid weight. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                String rawOtherA = reader.getString(this.format.getOtherAllele());
                if (rawOtherA.isEmpty()) {
                    this.warning("Row " + row + ": Other allele is empty. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                String alleleA = rawOtherA.trim();
                String rawEffectAllele = reader.getString(this.format.getEffectAllele());
                if (rawEffectAllele.isEmpty()) {
                    this.warning("Row " + row + ": Effect allele is empty. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                String effectAllele = rawEffectAllele.trim();
                ReferenceVariant variant = new ReferenceVariant(alleleA, effectAllele, effectWeight);
                this.variants.put(position, variant);
                ++this.loadedVariants;
                if (proxyReader == null) continue;
                for (ProxyReader.ProxySnp proxySnp : proxySnps = proxyReader.getByPosition(chromosome, position, alleleA, effectAllele)) {
                    try {
                        ReferenceVariant variant2 = new ReferenceVariant(proxySnp.mapAllele(alleleA), proxySnp.mapAllele(effectAllele), effectWeight);
                        variant2.setParent(variant);
                        ++this.loadedProxies;
                        if (this.variants.containsKey(proxySnp.getPosition())) continue;
                        this.variants.put(proxySnp.getPosition(), variant2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Mapping failed: " + position + ":" + e);
                    }
                }
            }
            reader.close();
        }
        catch (Exception e) {
            throw new IOException("Build Index for '" + this.filename + "' and chr '" + chromosome + "' failed: " + e.getMessage(), e);
        }
    }

    public boolean contains(int position) {
        return this.variants.containsKey(position);
    }

    public ReferenceVariant getVariant(int position) {
        return this.variants.get(position);
    }

    public static String getName(String filename) throws Exception {
        if (PGSCatalog.isValidId(filename)) {
            return filename;
        }
        String name = FileUtil.getFilename((String)filename);
        name = name.replaceAll(".txt.gz", "");
        name = name.replaceAll(".txt", "");
        name = name.replaceAll(".csv.gz", "");
        name = name.replaceAll(".csv", "");
        return name;
    }

    public int getLoadedVariants() {
        return this.loadedVariants;
    }

    public int getLoadedProxies() {
        return this.loadedProxies;
    }

    public int getTotalVariants() {
        return this.totalVariants;
    }

    private DataInputStream openTxtOrGzipStream(String filename) throws IOException {
        FileInputStream inputStream = new FileInputStream(filename);
        InputStream in2 = FileUtil.decompressStream((InputStream)inputStream);
        return new DataInputStream(in2);
    }

    public String toString() {
        return this.format.toString();
    }

    public RiskScoreFormatImpl getFormat() {
        return this.format;
    }

    public int getIgnoredVariants() {
        return this.ignoredVariants;
    }

    public Map<Integer, ReferenceVariant> getVariants() {
        return this.variants;
    }

    public void warning(String text) {
        if (VERBOSE) {
            System.out.println("Warning: " + text);
        }
    }
}

