/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.reader.ITableReader;
import genepi.riskscore.model.Population;
import genepi.riskscore.model.PopulationMap;
import genepi.riskscore.model.Sample;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SamplesFile {
    private String filename;
    private Map<String, Sample> samples;
    private int totalSamples = 0;
    public static final char SEPARATOR = '\t';
    public static final String COLUMN_POPULATION = "population";

    public SamplesFile(String filename) throws Exception {
        this.filename = filename;
        this.samples = new HashMap<String, Sample>();
        if (!new File(filename).exists()) {
            throw new Exception("File '" + filename + "' not found.");
        }
        CsvTableReader reader = new CsvTableReader(filename, '\t');
        this.checkFileFormat((ITableReader)reader, filename);
        reader.close();
    }

    private void checkFileFormat(ITableReader reader, String filename) throws Exception {
        if (!reader.hasColumn("sample")) {
            throw new Exception("Column 'sample' not found in '" + filename + "'");
        }
    }

    public void buildIndex() throws IOException {
        CsvTableReader reader = new CsvTableReader(this.filename, '\t');
        while (reader.next()) {
            String sample = reader.getString("sample");
            String population = Sample.UNKNOWN_POPULATION;
            if (reader.hasColumn(COLUMN_POPULATION)) {
                population = reader.getString(COLUMN_POPULATION);
            }
            this.samples.put(sample, new Sample(sample, population));
            ++this.totalSamples;
        }
        reader.close();
    }

    public boolean contains(String sample) {
        return this.samples.containsKey(sample);
    }

    public int getTotalSamples() {
        return this.totalSamples;
    }

    public PopulationMap getPopulations() {
        PopulationMap populations = new PopulationMap();
        for (Sample sample : this.samples.values()) {
            populations.addSample(sample.getPopulation());
        }
        return populations;
    }

    public List<String> getSamples(Population population) {
        Vector<String> result = new Vector<String>();
        for (Sample sample : this.samples.values()) {
            if (!sample.getPopulation().equals(population.getName())) continue;
            result.add(sample.getId());
        }
        return result;
    }
}

