/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.FileUtil;
import genepi.io.text.LineReader;
import java.io.File;
import java.util.Vector;

public class ScoresFile {
    private String filename;
    public static final String COLUMN_ID = "SCORES";

    public ScoresFile(String filename) {
        this.filename = filename;
    }

    public String[] getFilenames() throws Exception {
        if (!new File(this.filename).exists()) {
            throw new Exception("File '" + this.filename + "' not found.");
        }
        LineReader reader = new LineReader(this.filename);
        if (!reader.next()) {
            throw new Exception("File '" + this.filename + "' is empty.");
        }
        String header = reader.get();
        if (!header.equalsIgnoreCase(COLUMN_ID)) {
            throw new Exception("Column 'SCORES' not found in '" + this.filename + "'");
        }
        String path = new File(this.filename).getAbsoluteFile().getParent();
        Vector<String> ids = new Vector<String>();
        while (reader.next()) {
            String id = reader.get();
            if (id.trim().isEmpty() || ids.contains(id)) continue;
            ids.add(FileUtil.path((String[])new String[]{path, id}));
        }
        reader.close();
        String[] result = new String[ids.size()];
        return ids.toArray(result);
    }
}

