/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.reader.ITableReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VariantFile {
    private String filename;
    private Map<String, Set<Integer>> variants;
    private int totalVariants = 0;
    public static final char SEPARATOR = '\t';
    public static final String SCORE = "score";
    public static final String CHROMOSOME = "chr_name";
    public static final String POSITION = "chr_position";
    public static final String R2 = "r2";
    public static final String INCLUDE = "INCLUDE";

    public VariantFile(String filename) throws Exception {
        this.filename = filename;
        this.variants = new HashMap<String, Set<Integer>>();
        if (!new File(filename).exists()) {
            throw new Exception("File '" + filename + "' not found.");
        }
        CsvTableReader reader = new CsvTableReader(filename, '\t');
        this.checkFileFormat((ITableReader)reader, filename);
        reader.close();
    }

    private void checkFileFormat(ITableReader reader, String filename) throws Exception {
        if (!reader.hasColumn(SCORE)) {
            throw new Exception("Column 'score' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(CHROMOSOME)) {
            throw new Exception("Column 'chr_name' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(POSITION)) {
            throw new Exception("Column 'chr_position' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(INCLUDE)) {
            throw new Exception("Column 'INCLUDE' not found in '" + filename + "'");
        }
    }

    public void buildIndex(String chromosome) throws IOException {
        CsvTableReader reader = new CsvTableReader(this.filename, '\t');
        while (reader.next()) {
            int include;
            String chromsomeVariant = reader.getString(CHROMOSOME);
            if (chromsomeVariant.equals(chromosome) && (include = reader.getInteger(INCLUDE)) == 1) {
                String score = reader.getString(SCORE);
                int position = reader.getInteger(POSITION);
                Set<Integer> variantsScore = this.variants.get(score);
                if (variantsScore == null) {
                    variantsScore = new HashSet<Integer>();
                    this.variants.put(score, variantsScore);
                }
                variantsScore.add(position);
            }
            ++this.totalVariants;
        }
        reader.close();
    }

    public boolean contains(String score, int position) {
        Set<Integer> variantsScore = this.variants.get(score);
        if (variantsScore != null) {
            return variantsScore.contains(position);
        }
        return false;
    }

    public int getCacheSize() {
        return this.variants.size();
    }

    public int getTotalVariants() {
        return this.totalVariants;
    }
}

