/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.csv;

import genepi.io.FileUtil;
import genepi.io.table.reader.CsvTableReader;
import genepi.io.text.LineReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;

public class CsvWithHeaderTableReader
extends CsvTableReader {
    private List<String> headerLines = new Vector<String>();

    public CsvWithHeaderTableReader(String filename, char seperator) throws IOException {
        super(filename, seperator);
        LineReader reader = new LineReader(CsvWithHeaderTableReader.openTxtOrGzipStream(filename));
        while (reader.next() && reader.get().startsWith("#")) {
            this.headerLines.add(reader.get());
        }
        reader.close();
    }

    public List<String> getHeader() {
        return this.headerLines;
    }

    private static DataInputStream openTxtOrGzipStream(String filename) throws IOException {
        FileInputStream inputStream = new FileInputStream(filename);
        InputStream in2 = FileUtil.decompressStream((InputStream)inputStream);
        return new DataInputStream(in2);
    }
}

