/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.csv;

import au.com.bytecode.opencsv.CSVWriter;
import genepi.io.table.writer.AbstractTableWriter;
import genepi.io.text.LineWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsvWithHeaderTableWriter
extends AbstractTableWriter {
    private CSVWriter writer;
    public String[] currentLine;
    private Map<String, Integer> columns2Index = new HashMap<String, Integer>();

    public CsvWithHeaderTableWriter(String filename, char separator, List<String> header) {
        try {
            LineWriter lineWriter = new LineWriter(filename);
            for (String line : header) {
                lineWriter.write(line.replace("\n", "").replace("\r", ""));
            }
            if (!header.isEmpty()) {
                lineWriter.write("# Updated by pgs-calc 1.5.1\n");
            }
            lineWriter.close();
            this.writer = new CSVWriter((Writer)new FileWriter(filename, true), separator, '\u0000', '\u0000');
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getColumnIndex(String column) {
        return this.columns2Index.get(column);
    }

    public boolean next() {
        this.writer.writeNext(this.currentLine);
        for (int i = 0; i < this.currentLine.length; ++i) {
            this.currentLine[i] = "";
        }
        return true;
    }

    public void setColumns(String[] columns) {
        this.currentLine = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.columns2Index.put(columns[i], i);
            this.currentLine[i] = "";
        }
        this.writer.writeNext(columns);
    }

    public void setDouble(int column, double value) {
        this.currentLine[column] = value + "";
    }

    public void setInteger(int column, int value) {
        this.currentLine[column] = value + "";
    }

    public void setString(int column, String value) {
        this.currentLine[column] = value;
    }

    public void setRow(String[] row) {
        this.currentLine = row;
    }
}

