/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.dbsnp;

import genepi.io.text.LineReader;
import htsjdk.tribble.readers.TabixReader;
import java.io.IOException;

public class DbSnpReader {
    private TabixReader reader;
    private int size = 3;

    public DbSnpReader(String input) throws IOException {
        String line;
        LineReader headerReader = new LineReader(input);
        while (headerReader.next() && (line = headerReader.get()).startsWith("#")) {
            String[] tiles = line.split("=");
            if (tiles.length != 2) continue;
            String key = tiles[0];
            String value = tiles[1];
            if (!key.equalsIgnoreCase("#size")) continue;
            this.size = Integer.parseInt(value);
        }
        headerReader.close();
        this.reader = new TabixReader(input);
    }

    public Snp getByRsId(String rs) throws IOException {
        TabixReader.Iterator result = this.reader.query(DbSnpReader.getContig(rs, this.size), DbSnpReader.getPosition(rs, this.size) - 1, DbSnpReader.getPosition(rs, this.size));
        String line = result.next();
        if (line != null) {
            String[] tiles = line.split("\t");
            if (tiles.length == 6) {
                Snp snp = new Snp();
                snp.setChromosome(tiles[2]);
                snp.setPosition(Integer.parseInt(tiles[3]));
                snp.setReference(tiles[4].replaceAll("\\*", ""));
                snp.setAlternate(tiles[5]);
                return snp;
            }
            throw new IOException("Index has not 6 columns.");
        }
        return null;
    }

    public void close() {
        this.reader.close();
    }

    public static String getContig(String rsID, int size) {
        if (rsID.length() > 10) {
            String position = rsID.substring(size);
            int count = DbSnpReader.countCharacter(position, '0');
            return rsID.substring(0, size) + DbSnpReader.sequence('0', count);
        }
        String position = rsID.substring(2);
        int count = DbSnpReader.countCharacter(position, '0');
        return "rs" + DbSnpReader.sequence('0', count);
    }

    public static int getPosition(String rsID, int size) {
        if (rsID.length() > 10) {
            return Integer.parseInt(rsID.substring(size));
        }
        return Integer.parseInt(rsID.substring(2));
    }

    public static int countCharacter(String string, char character) {
        int count = 0;
        for (int i = 0; i < string.length() && string.charAt(i) == character; ++i) {
            ++count;
        }
        return count;
    }

    public static String sequence(char character, int count) {
        String result = "";
        for (int i = 0; i < count; ++i) {
            result = result + character;
        }
        return result;
    }

    public class Snp {
        private String chromosome;
        private long position;
        private String reference;
        private String alternate;

        public String getChromosome() {
            return this.chromosome;
        }

        public void setChromosome(String chromosome) {
            this.chromosome = chromosome;
        }

        public long getPosition() {
            return this.position;
        }

        public void setPosition(long position) {
            this.position = position;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getReference() {
            return this.reference;
        }

        public void setAlternate(String alternate) {
            this.alternate = alternate;
        }

        public String getAlternate() {
            return this.alternate;
        }

        public String toString() {
            return this.chromosome + ":" + this.position + ":" + this.reference;
        }
    }
}

