/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.formats;

import genepi.io.FileUtil;
import genepi.riskscore.io.formats.PGSCatalogFormat;
import genepi.riskscore.io.formats.PRSwebFormat;
import genepi.riskscore.io.formats.RiskScoreFormatImpl;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RiskScoreFormatFactory {
    public static RiskScoreFormatImpl buildFormat(String filename, RiskScoreFormat format) throws IOException {
        switch (format) {
            case AUTO_DETECT: {
                String headerLine = RiskScoreFormatFactory.readHeader(filename);
                if (headerLine.startsWith("## PRSweb")) {
                    return new PRSwebFormat();
                }
                return new PGSCatalogFormat(filename, false);
            }
            case DEFAULT: {
                return new RiskScoreFormatImpl();
            }
            case MAPPING_FILE: {
                return RiskScoreFormatImpl.load(filename + ".format");
            }
        }
        return new RiskScoreFormatImpl();
    }

    protected static String readHeader(String filename) throws IOException {
        DataInputStream in = RiskScoreFormatFactory.openTxtOrGzipStream(filename);
        String line = in.readLine();
        in.close();
        return line;
    }

    private static DataInputStream openTxtOrGzipStream(String filename) throws IOException {
        FileInputStream inputStream = new FileInputStream(filename);
        InputStream in2 = FileUtil.decompressStream((InputStream)inputStream);
        return new DataInputStream(in2);
    }

    public static enum RiskScoreFormat {
        DEFAULT,
        AUTO_DETECT,
        MAPPING_FILE;

    }
}

