/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.meta;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import genepi.io.text.LineWriter;
import genepi.riskscore.io.MetaFile;
import genepi.riskscore.model.ScorePopulationMap;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PGSCatalogMetaFile {
    protected Map<String, MetaFile.MetaScore> index;
    protected String next;

    private PGSCatalogMetaFile() {
    }

    public static PGSCatalogMetaFile load(String filename) throws JsonIOException, JsonSyntaxException, FileNotFoundException {
        PGSCatalogMetaFile file = new PGSCatalogMetaFile();
        Gson gson = new Gson();
        Type type = new TypeToken<List<Map>>(){}.getType();
        Object data = gson.fromJson((Reader)new FileReader(filename), Object.class);
        Object results = ((AbstractMap)data).get("results");
        file.next = ((AbstractMap)data).get("next") != null ? ((AbstractMap)data).get("next").toString() : null;
        List list = (List)results;
        file.index = new HashMap<String, MetaFile.MetaScore>();
        for (Object score : list) {
            MetaFile.MetaScore metaScore = PGSCatalogMetaFile.parsePGSCatalog((AbstractMap)score);
            file.index.put(metaScore.getId(), metaScore);
        }
        return file;
    }

    public void merge(PGSCatalogMetaFile metaFile) {
        this.index.putAll(metaFile.index);
    }

    public int getScores() {
        return this.index.size();
    }

    public String getNext() {
        return this.next;
    }

    public void save(String filename) throws IOException {
        Gson gson = new Gson();
        Type type = new TypeToken<List<Map>>(){}.getType();
        String json = gson.toJson(this.index);
        LineWriter writer = new LineWriter(filename);
        writer.write(json);
        writer.close();
    }

    protected static MetaFile.MetaScore parsePGSCatalog(AbstractMap<String, Object> data) {
        Object efos;
        Object publication;
        Object samplesVariants;
        Object gwas;
        MetaFile.MetaScore score = new MetaFile.MetaScore();
        String id = data.get("id").toString();
        String trait = data.get("trait_reported").toString();
        score.setId(id);
        score.setTrait(trait);
        Object ancestry_distribution = data.get("ancestry_distribution");
        if (ancestry_distribution != null && (gwas = ((Map)ancestry_distribution).get("gwas")) != null && (samplesVariants = ((Map)gwas).get("dist")) != null) {
            ScorePopulationMap populationMap = new ScorePopulationMap();
            Map items = (Map)samplesVariants;
            for (String key : items.keySet()) {
                populationMap.addSamples(key, ((Double)items.get(key)).floatValue() / 100.0f);
            }
            score.setPopulations(populationMap);
            Double samples = (Double)((Map)gwas).get("count");
            populationMap.total = samples.intValue();
            score.setSamples(samples.intValue());
        }
        if ((publication = data.get("publication")) != null) {
            Map publicationMap = (Map)publication;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("doi", (String)publicationMap.get("doi"));
            map.put("firstauthor", (String)publicationMap.get("firstauthor"));
            map.put("journal", (String)publicationMap.get("journal"));
            map.put("date", (String)publicationMap.get("date_publication"));
            score.setPublication(map);
        }
        if ((efos = data.get("trait_efo")) != null) {
            score.setEfo((List)efos);
        }
        score.setVariants(((Double)data.get("variants_number")).intValue());
        score.setRepository("PGS-Catalog");
        score.setLink("https://www.pgscatalog.org/score/" + id);
        return score;
    }
}

