/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.vcf;

import genepi.io.FileUtil;
import genepi.io.reader.IReader;
import genepi.riskscore.io.vcf.MinimalVariantContext;
import genepi.riskscore.io.vcf.VCFLineParser;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;

public class FastVCFFileReader
implements IReader<MinimalVariantContext> {
    private List<String> samples;
    private int snpsCount = 0;
    private int samplesCount = 0;
    private MinimalVariantContext variantContext;
    private VCFLineParser parser;
    private String filename;
    protected BufferedReader in;
    private int lineNumber = 0;

    public FastVCFFileReader(InputStream inputStream, String vcfFilename) throws IOException {
        VCFFileReader reader = new VCFFileReader(new File(vcfFilename), false);
        VCFHeader header = reader.getFileHeader();
        this.samples = header.getGenotypeSamples();
        this.samplesCount = this.samples.size();
        this.variantContext = new MinimalVariantContext(this.samplesCount);
        reader.close();
        this.filename = vcfFilename;
        InputStream in2 = FileUtil.decompressStream((InputStream)inputStream);
        this.in = new BufferedReader(new InputStreamReader(in2));
        this.parser = new VCFLineParser(this.samplesCount);
    }

    public FastVCFFileReader(String vcfFilename) throws IOException {
        this(new FileInputStream(vcfFilename), vcfFilename);
    }

    public List<String> getGenotypedSamples() {
        return this.samples;
    }

    public MinimalVariantContext get() {
        return this.variantContext;
    }

    public int getSnpsCount() {
        return this.snpsCount;
    }

    public int getSamplesCount() {
        return this.samplesCount;
    }

    public boolean next() throws IOException {
        String line;
        while ((line = this.in.readLine()) != null) {
            try {
                ++this.lineNumber;
                if (line.trim().isEmpty() || line.charAt(0) == '#') continue;
                this.parseLine(line);
                return true;
            }
            catch (Exception e) {
                throw new IOException(this.filename + ": Line " + this.lineNumber + ": " + e.getMessage());
            }
        }
        return false;
    }

    protected void parseLine(String line) throws IOException {
        this.variantContext = this.parser.parseLine(line);
        if (this.variantContext.getNSamples() != this.samplesCount) {
            throw new IOException("Line " + this.lineNumber + ": different number of samples.");
        }
        ++this.snpsCount;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public Iterator<MinimalVariantContext> iterator() {
        return null;
    }

    public void reset() {
    }
}

