/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.vcf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MinimalVariantContext {
    public static final String NO_FILTERS = "";
    private int start;
    private String contig;
    private String referenceAllele;
    private String alternateAllele;
    private int hetCount;
    private int homRefCount;
    private int homVarCount;
    private int noCallCount;
    private int nSamples;
    private String rawLine;
    private String filters;
    private boolean[] genotypes;
    private float[] genotypesParsed;
    private String id = null;
    private String genotype = null;
    private String info = null;
    private Map<String, String> infos;
    private boolean dirtyGenotypes = true;
    private boolean missingData = false;

    public MinimalVariantContext(int samples) {
        this.genotypes = new boolean[samples];
        this.genotypesParsed = new float[samples];
    }

    public int getHetCount() {
        return this.hetCount;
    }

    public void setHetCount(int hetCount) {
        this.hetCount = hetCount;
        this.id = null;
    }

    public int getHomRefCount() {
        return this.homRefCount;
    }

    public void setHomRefCount(int homRefCount) {
        this.homRefCount = homRefCount;
        this.id = null;
    }

    public int getHomVarCount() {
        return this.homVarCount;
    }

    public void setHomVarCount(int homVarCount) {
        this.homVarCount = homVarCount;
        this.id = null;
    }

    public int getNoCallCount() {
        return this.noCallCount;
    }

    public void setNoCallCount(int noCallCount) {
        this.noCallCount = noCallCount;
        this.id = null;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
        this.id = null;
    }

    public String getContig() {
        return this.contig.replaceAll("chr", NO_FILTERS);
    }

    public void setContig(String contig) {
        this.contig = contig;
        this.id = null;
    }

    public String getReferenceAllele() {
        return this.referenceAllele;
    }

    public void setReferenceAllele(String referenceAllele) {
        this.referenceAllele = referenceAllele;
        this.id = null;
        this.genotype = null;
    }

    public String getAlternateAllele() {
        return this.alternateAllele;
    }

    public void setAlternateAllele(String alternateAllele) {
        this.alternateAllele = alternateAllele;
        this.id = null;
        this.genotype = null;
    }

    public void setNSamples(int nSamples) {
        this.nSamples = nSamples;
        this.id = null;
    }

    public int getNSamples() {
        return this.nSamples;
    }

    public void setRawLine(String rawLine) {
        this.rawLine = rawLine;
        this.id = null;
        this.dirtyGenotypes = true;
    }

    public String getRawLine() {
        return this.rawLine;
    }

    public boolean isFiltered() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
        this.id = null;
    }

    public boolean isIndel() {
        return this.getReferenceAllele().length() > 1 || this.getAlternateAllele().length() > 1;
    }

    public boolean isComplexIndel() {
        return this.getReferenceAllele().length() > 1 || this.getAlternateAllele().length() > 1;
    }

    public boolean isMonomorphicInSamples() {
        return this.homRefCount + this.noCallCount == this.nSamples;
    }

    public void setCalled(int sample, boolean called) {
        this.genotypes[sample] = called;
        this.id = null;
    }

    public boolean isCalled(int sample) {
        return this.genotypes[sample];
    }

    public boolean isAmbigous() {
        return this.getReferenceAllele().equals("A") && this.getAlternateAllele().equals("T") || this.getReferenceAllele().equals("T") && this.getAlternateAllele().equals("A") || this.getReferenceAllele().equals("G") && this.getAlternateAllele().equals("C") || this.getReferenceAllele().equals("C") && this.getAlternateAllele().equals("G");
    }

    public String getGenotype() {
        if (this.genotype == null) {
            StringBuilder builder = new StringBuilder(2);
            builder.append(this.referenceAllele);
            builder.append(this.alternateAllele);
            this.genotype = builder.toString();
        }
        return this.genotype;
    }

    public String toString() {
        if (this.id == null) {
            StringBuilder builder = new StringBuilder(7);
            builder.append(this.getContig());
            builder.append(":");
            builder.append(this.getStart());
            builder.append(":");
            builder.append(this.getReferenceAllele());
            builder.append(":");
            builder.append(this.getAlternateAllele());
            this.id = builder.toString();
        }
        return this.id;
    }

    public void setInfo(String info) {
        this.info = info;
        this.infos = null;
    }

    public String getInfo(String key) {
        if (this.infos == null) {
            this.infos = new HashMap<String, String>();
            String[] tiles = this.info.split(";");
            for (int i = 0; i < tiles.length; ++i) {
                String[] tiles2 = tiles[i].split("=");
                if (tiles2.length != 2) continue;
                this.infos.put(tiles2[0], tiles2[1]);
            }
        }
        return this.infos.get(key);
    }

    public double getInfoAsDouble(String key, double defaultValue) {
        String value = this.getInfo(key);
        if (value != null && !value.isEmpty() && !value.equals(".")) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public boolean hasMissingGenotypes(String field) throws IOException {
        this.getGenotypeDosages(field);
        return this.missingData;
    }

    public float[] getGenotypeDosages(String field) throws IOException {
        if (this.dirtyGenotypes) {
            String[] tiles = this.rawLine.split("\t", 10);
            String format = tiles[8];
            String[] formats = format.split(":");
            String[] values = tiles[9].split("\t");
            if (field.equals("DS")) {
                int indexDS = this.findField(formats, "DS");
                int indexGT = this.findField(formats, "GT");
                if (indexDS != -1) {
                    this.parseDosages(values, indexDS, indexGT);
                } else {
                    System.out.println("Variant '" + this + "': Field 'DS' not found in FORMAT. Try 'GT'");
                    if (indexGT == -1) {
                        throw new IOException("Variant '" + this + "': Field 'GT' not found in FORMAT. Available: " + format);
                    }
                    this.parseGenotypes(values, indexGT);
                }
            } else {
                int indexGT = this.findField(formats, "GT");
                if (indexGT == -1) {
                    throw new IOException("Variant '" + this + "': Field 'GT' not found in FORMAT. Available: " + format);
                }
                this.parseGenotypes(values, indexGT);
            }
            this.dirtyGenotypes = false;
        }
        return this.genotypesParsed;
    }

    protected int findField(String[] formats, String field) {
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].equals(field)) continue;
            return i;
        }
        return -1;
    }

    protected void parseGenotypes(String[] values, int indexGT) {
        for (int i = 0; i < this.genotypesParsed.length; ++i) {
            String value = values[i];
            String[] tiles2 = value.split(":");
            String genotype = tiles2[indexGT];
            try {
                float dosage;
                this.genotypesParsed[i] = dosage = this.toDosage(genotype);
                continue;
            }
            catch (Exception e) {
                this.genotypesParsed[i] = -1.0f;
                this.missingData = true;
            }
        }
    }

    protected void parseDosages(String[] values, int indexDS, int indexGT) {
        this.missingData = false;
        for (int i = 0; i < this.genotypesParsed.length; ++i) {
            String value = values[i];
            String[] tiles2 = value.split(":");
            try {
                if (tiles2.length == 1) {
                    String genotype = tiles2[indexGT];
                    this.genotypesParsed[i] = this.toDosage(genotype);
                    continue;
                }
                String dosage = tiles2[indexDS];
                if (dosage.equals(".")) {
                    String genotype = tiles2[indexGT];
                    this.genotypesParsed[i] = this.toDosage(genotype);
                    continue;
                }
                this.genotypesParsed[i] = Float.parseFloat(dosage);
                continue;
            }
            catch (Exception e) {
                this.genotypesParsed[i] = -1.0f;
                this.missingData = true;
            }
        }
    }

    protected float toDosage(String genotype) throws Exception {
        if (genotype.equals("0|0") || genotype.equals("0/0")) {
            return 0.0f;
        }
        if (genotype.equals("0|1") || genotype.equals("1|0") || genotype.equals("0/1") || genotype.equals("1/0")) {
            return 1.0f;
        }
        if (genotype.equals("1|1") || genotype.equals("1/1")) {
            return 2.0f;
        }
        throw new Exception("Unknown genotype: " + genotype);
    }
}

