/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.model;

import genepi.riskscore.model.Population;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PopulationMap {
    private Map<String, Population> items = new HashMap<String, Population>();
    public int total = 0;

    public void addSample(String population) {
        this.addSamples(population, 1);
    }

    public void addSamples(String population, int count) {
        Population item = this.items.get(population);
        if (item == null) {
            item = new Population();
            item.setName(population);
            item.setCount(0);
            this.items.put(population, item);
        }
        item.setCount(item.getCount() + count);
        this.total += count;
        for (Population _item : this.items.values()) {
            _item.setPercentage((float)_item.getCount() / (float)this.total);
        }
    }

    public List<Population> getPopulations() {
        Vector<Population> result = new Vector<Population>();
        for (Population item : this.items.values()) {
            result.add(item);
        }
        Collections.sort(result);
        return result;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean supports(String population) {
        return this.items.containsKey(population);
    }

    public boolean supports(Population population) {
        return this.items.containsKey(population.getName());
    }
}

