/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.model;

import genepi.riskscore.io.MetaFile;
import genepi.riskscore.io.SamplesFile;
import genepi.riskscore.model.Population;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;

public class RiskScoreSummary {
    private String name;
    private int variants = 0;
    private int variantsUsed = 0;
    private int variantsIgnored = 0;
    private double coverage = 0.0;
    private int variantsSwitched = 0;
    private int variantsMultiAllelic = 0;
    private int variantsAlleleMissmatch = 0;
    private int r2Filtered = 0;
    private int notFound = 0;
    private int filtered = 0;
    private int ambiguous = 0;
    private int flipped = 0;
    private int strandFlips = 0;
    private int proxiesUsed = 0;
    private MetaFile.MetaScore meta;
    private double[] data;
    private String coverageLabel;
    private int missingGenotypes = 0;
    private String populationCheckMessage = "";
    private boolean populationCheckStatus = true;
    private double[] excluded;
    private int samples;
    private float samplesPercentage;

    public RiskScoreSummary(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getVariantsUsed() {
        return this.variantsUsed;
    }

    public void incVariantsUsed() {
        ++this.variantsUsed;
        this.coverage = this.getVariantsUsed() / this.getVariants();
    }

    public int getSwitched() {
        return this.variantsSwitched;
    }

    public void incSwitched() {
        ++this.variantsSwitched;
    }

    public int getMultiAllelic() {
        return this.variantsMultiAllelic;
    }

    public void incMultiAllelic() {
        ++this.variantsMultiAllelic;
    }

    public int getAlleleMissmatch() {
        return this.variantsAlleleMissmatch;
    }

    public void incAlleleMissmatch() {
        ++this.variantsAlleleMissmatch;
    }

    public int getR2Filtered() {
        return this.r2Filtered;
    }

    public void incR2Filtered() {
        ++this.r2Filtered;
    }

    public int getVariants() {
        return this.variants;
    }

    public void setVariants(int count) {
        this.variants = count;
        this.coverage = this.getVariantsUsed() / this.getVariants();
    }

    public int getNotFound() {
        return this.notFound;
    }

    public void incNotFound() {
        ++this.notFound;
    }

    public int getFiltered() {
        return this.filtered;
    }

    public void incFiltered() {
        ++this.filtered;
    }

    public int getAmbiguous() {
        return this.ambiguous;
    }

    public void incAmbiguous() {
        ++this.ambiguous;
    }

    public int getVariantsNotUsed() {
        return this.variants - this.variantsUsed;
    }

    public void setCoverage(double coverage) {
    }

    public double getCoverage() {
        return this.coverage;
    }

    public void setMeta(MetaFile.MetaScore meta) {
        this.meta = meta;
    }

    public MetaFile.MetaScore getMeta() {
        return this.meta;
    }

    public void setData(double[] data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setCoverageLabel(String coverageLabel) {
    }

    public String getCoverageLabel() {
        return this.coverageLabel;
    }

    public void setVariantsIgnored(int variantsIgnored) {
        this.variantsIgnored = variantsIgnored;
    }

    public int getVariantsIgnored() {
        return this.variantsIgnored;
    }

    public int getFlipped() {
        return this.flipped;
    }

    public void setFlipped(int flipped) {
        this.flipped = flipped;
    }

    public void incFlipped() {
        ++this.flipped;
    }

    public int getStrandFlips() {
        return this.strandFlips;
    }

    public void setStrandFlips(int strandFlips) {
        this.strandFlips = strandFlips;
    }

    public void incStrandFlips() {
        ++this.strandFlips;
    }

    public void setProxiesUsed(int proxiesUsed) {
        this.proxiesUsed = proxiesUsed;
    }

    public int getProxiesUsed() {
        return this.proxiesUsed;
    }

    public void incProxiesUsed() {
        ++this.proxiesUsed;
    }

    public int getMissingGenotypes() {
        return this.missingGenotypes;
    }

    public void setMissingGenotypes(int missingGenotypes) {
        this.missingGenotypes = missingGenotypes;
    }

    public void incMissingGenotypes() {
        ++this.missingGenotypes;
    }

    public void setPopulationCheckMessage(String populationCheckMessage) {
        this.populationCheckMessage = populationCheckMessage;
    }

    public String getPopulationCheckMessage() {
        return this.populationCheckMessage;
    }

    public void setPopulationCheckStatus(boolean populationCheckStatus) {
        this.populationCheckStatus = populationCheckStatus;
    }

    public boolean isPopulationCheckStatus() {
        return this.populationCheckStatus;
    }

    public void checkPopulation(List<String> samples, SamplesFile file) {
        this.populationCheckStatus = true;
        if (file == null) {
            this.populationCheckMessage = "No population information available for your samples. Be careful for population stratification.";
            this.populationCheckStatus = false;
            return;
        }
        if (this.meta == null || this.meta.getPopulations() == null || this.meta.getPopulations().getTotal() == 0) {
            this.populationCheckMessage = "No population information available for this score. Be careful for population stratification.";
            this.populationCheckStatus = false;
            return;
        }
        this.populationCheckMessage = "";
        HashSet<String> excludedSamples = new HashSet<String>();
        for (Population pop : file.getPopulations().getPopulations()) {
            if (this.meta.getPopulations().supports(pop)) continue;
            this.populationCheckMessage = this.populationCheckMessage + "Excluded <b>" + pop.getCount() + " sample(s)</b> (" + pop.getLabel() + ") due to ancestry mismatch.<br>";
            this.populationCheckStatus = false;
            excludedSamples.addAll(file.getSamples(pop));
        }
        if (this.data == null) {
            return;
        }
        if (!this.populationCheckStatus && !excludedSamples.isEmpty()) {
            double[] oldData = this.data;
            this.data = new double[oldData.length - excludedSamples.size()];
            this.excluded = new double[excludedSamples.size()];
            int dataIndex = 0;
            int excludedIndex = 0;
            for (int i = 0; i < oldData.length; ++i) {
                String sample = samples.get(i);
                if (excludedSamples.contains(sample)) {
                    this.excluded[excludedIndex] = oldData[i];
                    ++excludedIndex;
                    continue;
                }
                this.data[dataIndex] = oldData[i];
                ++dataIndex;
            }
        }
        this.samples = this.data.length;
        this.samplesPercentage = (float)this.samples / (float)samples.size();
    }

    public double[] getExcluded() {
        return this.excluded;
    }

    public void setExcluded(double[] excluded) {
        this.excluded = excluded;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setSamples(int samples) {
        this.samples = samples;
    }

    public float getSamplesPercentage() {
        return this.samplesPercentage;
    }

    public void setSamplesPercentage(float samplesPercentage) {
        this.samplesPercentage = samplesPercentage;
    }

    public void updateStatistics() {
        this.coverage = (double)this.getVariantsUsed() / (double)this.getVariants();
        this.coverageLabel = this.getVariantsUsed() == 0 ? "zero" : (this.coverage <= 0.25 ? "low" : (this.coverage > 0.25 && this.coverage <= 0.75 ? "medium" : "high"));
    }

    public void merge(RiskScoreSummary other) throws Exception {
        if (!other.name.equals(this.name)) {
            throw new Exception("Different score names: '" + this.name + "' vs. '" + other.name + "'.");
        }
        this.variantsUsed += other.variantsUsed;
        this.variantsIgnored += other.variantsIgnored;
        this.variantsSwitched += other.variantsSwitched;
        this.variantsMultiAllelic += other.variantsMultiAllelic;
        this.variantsAlleleMissmatch += other.variantsAlleleMissmatch;
        this.r2Filtered += other.r2Filtered;
        this.notFound += other.notFound;
        this.filtered += other.filtered;
        this.ambiguous += other.ambiguous;
        this.flipped += other.flipped;
        this.strandFlips += other.strandFlips;
        this.missingGenotypes += other.missingGenotypes;
        this.updateStatistics();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  " + this.name + ":\n");
        buffer.append("    - Variants: " + RiskScoreSummary.number(this.getVariants()) + "\n");
        buffer.append("    - Variants ignored: " + RiskScoreSummary.number(this.getVariantsIgnored()) + "\n");
        buffer.append("    - Variants used: " + RiskScoreSummary.number(this.getVariantsUsed()) + " (" + RiskScoreSummary.percentage(this.getVariantsUsed(), this.getVariants()) + ")\n");
        buffer.append("    - Proxies used: " + RiskScoreSummary.number(this.getProxiesUsed()) + "\n");
        buffer.append("    - Found in target and filtered by:\n");
        buffer.append("      - ambiguous: " + RiskScoreSummary.number(this.getAmbiguous()) + "\n");
        buffer.append("      - strand flip: " + RiskScoreSummary.number(this.getStrandFlips()) + "\n");
        buffer.append("      - allele mismatch: " + RiskScoreSummary.number(this.getAlleleMissmatch()) + "\n");
        buffer.append("      - multi allelic or indels: " + RiskScoreSummary.number(this.getMultiAllelic()) + "\n");
        buffer.append("      - low R2 value: " + RiskScoreSummary.number(this.getR2Filtered()) + "\n");
        buffer.append("      - missing genotypes: " + RiskScoreSummary.number(this.getMissingGenotypes()) + "\n");
        buffer.append("      - variants file: " + RiskScoreSummary.number(this.getFiltered()) + "\n");
        buffer.append("    - Strand Flips fixed: " + RiskScoreSummary.number(this.getFlipped()) + "\n");
        int notFound = this.getVariants() - (this.getVariantsUsed() + this.getFiltered() + this.getAlleleMissmatch() + this.getMultiAllelic() + this.getR2Filtered() + this.getAmbiguous());
        return buffer.toString();
    }

    public static String number(long number) {
        DecimalFormat formatter = new DecimalFormat("###,###,###");
        return formatter.format(number);
    }

    public static String percentage(double obtained, double total) {
        double percentage = obtained / total * 100.0;
        DecimalFormat df = new DecimalFormat("###.##'%'");
        return df.format(percentage);
    }

    public void updateColorAndLabel() {
        if (this.meta != null && this.meta.getPopulations() != null) {
            this.meta.getPopulations().updateColorAndLabel();
        }
    }
}

