/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.model;

import genepi.riskscore.model.Population;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ScorePopulationMap {
    private Map<String, Population> items = new HashMap<String, Population>();
    public int total = 0;

    public void addSample(String population) {
        this.addSamples(population, 1.0f);
    }

    public void addSamples(String population, float percentage) {
        Population item = this.items.get(population);
        item = new Population();
        item.setName(population);
        item.setCount(-1);
        item.setPercentage(percentage);
        this.items.put(population, item);
    }

    public List<Population> getPopulations() {
        Vector<Population> result = new Vector<Population>();
        for (Population item : this.items.values()) {
            result.add(item);
        }
        Collections.sort(result);
        return result;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean supports(String population) {
        return this.items.containsKey(population);
    }

    public boolean supports(Population population) {
        return this.items.containsKey(population.getName());
    }

    public void updateColorAndLabel() {
        for (Population item : this.items.values()) {
            item.updateColorAndLabel();
        }
    }
}

