/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.tasks;

import genepi.riskscore.App;
import genepi.riskscore.io.OutputFile;
import genepi.riskscore.io.ReportFile;
import genepi.riskscore.io.SamplesFile;
import genepi.riskscore.model.RiskScoreSummary;
import java.io.File;
import java.util.Comparator;
import java.util.Date;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;
import lukfor.reports.HtmlReport;

public class CreateHtmlReportTask
implements ITaskRunnable {
    public static final String TEMPLATE_DIRECTORY = "/templates";
    public static final String DEFAULT_TEMPLATE = "default";
    public static final String INDEX_FILE = "index.html";
    private String output;
    private ReportFile report;
    private OutputFile data;
    private SamplesFile samples;
    private boolean showCommand = true;
    private String application = "pgs-calc";
    private String applicationName = "PGS-Server";
    private String version = "1.5.1";
    private String url = "https://github.com/lukfor/pgs-calc";
    private String template = "default";

    public void setOutput(String output) {
        this.output = output;
    }

    public void setReport(ReportFile report) {
        this.report = report;
    }

    public void setData(OutputFile data) {
        this.data = data;
    }

    public void setSamples(SamplesFile samples) {
        this.samples = samples;
    }

    public void setShowCommand(boolean showCommand) {
        this.showCommand = showCommand;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void run(ITaskMonitor monitor) throws Exception {
        monitor.begin("Create HTML Report", -1L);
        assert (this.report != null);
        assert (this.output != null);
        HtmlReport report = new HtmlReport("/templates/" + this.template);
        report.setMainFilename(INDEX_FILE);
        report.set("createdOn", (Object)new Date());
        report.set("version", (Object)this.version);
        report.set("application", (Object)this.application);
        report.set("application_name", (Object)this.applicationName);
        if (this.showCommand) {
            String args = String.join((CharSequence)"\\<br>  ", App.ARGS);
            report.set("show_command", (Object)true);
            report.set("application_args", (Object)args);
        } else {
            report.set("show_command", (Object)false);
        }
        report.set("url", (Object)this.url);
        report.set("copyright", (Object)"(c) 2020 - 2022 Lukas Forer");
        if (this.data != null) {
            report.set("show_samples", (Object)true);
            report.set("samples", this.data.getSamples());
        } else {
            report.set("show_samples", (Object)false);
            report.set("samples", null);
        }
        for (int i = 0; i < this.report.getSummaries().size(); ++i) {
            if (this.report.getSummaries().get(i).getVariantsUsed() > 0 && this.data != null) {
                this.report.getSummaries().get(i).setData(this.data.getValuesByScore(i));
            }
            this.report.getSummaries().get(i).updateStatistics();
            this.report.getSummaries().get(i).updateColorAndLabel();
        }
        this.report.getSummaries().sort(new Comparator<RiskScoreSummary>(){

            @Override
            public int compare(RiskScoreSummary o1, RiskScoreSummary o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        report.set("scores", this.report.getSummaries());
        if (this.samples != null && this.data != null) {
            report.set("population_check", (Object)true);
            report.set("populations", (Object)this.samples.getPopulations());
            for (RiskScoreSummary score : this.report.getSummaries()) {
                score.checkPopulation(this.data.getSamples(), this.samples);
            }
        } else {
            for (RiskScoreSummary score : this.report.getSummaries()) {
                score.setPopulationCheckStatus(true);
            }
            report.set("population_check", (Object)false);
            report.set("populations", null);
        }
        report.setSelfContained(true);
        report.generate(new File(this.output));
        monitor.update("Html Report created and written to '" + this.output + "'");
        monitor.done();
    }
}

