/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.tasks;

import genepi.riskscore.io.csv.CsvWithHeaderTableReader;
import genepi.riskscore.io.csv.CsvWithHeaderTableWriter;
import genepi.riskscore.io.formats.RiskScoreFormatFactory;
import genepi.riskscore.io.formats.RiskScoreFormatImpl;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.util.Interval;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;

public class LiftOverScoreTask
implements ITaskRunnable {
    private String input = null;
    private String output = null;
    private int total = 0;
    private int resolved = 0;
    private int failed = 0;
    private int ignored;
    private String chainFile;
    public static boolean VERBOSE = false;
    public static final Map<Character, Character> ALLELE_SWITCHES = new HashMap<Character, Character>();

    public LiftOverScoreTask(String input, String output, String chainFile) {
        this.input = input;
        this.output = output;
        this.chainFile = chainFile;
    }

    public void run(ITaskMonitor monitor) throws Exception {
        RiskScoreFormatImpl format = RiskScoreFormatFactory.buildFormat(this.input, RiskScoreFormatFactory.RiskScoreFormat.AUTO_DETECT);
        if (new File(this.input + ".format").exists()) {
            format = RiskScoreFormatImpl.load(this.input + ".format");
        }
        CsvWithHeaderTableReader reader = new CsvWithHeaderTableReader(this.input, format.getSeparator());
        CsvWithHeaderTableWriter writer = new CsvWithHeaderTableWriter(this.output, format.getSeparator(), reader.getHeader());
        LiftOver liftOver = new LiftOver(new File(this.chainFile));
        int row = 0;
        writer.setColumns(reader.getColumns());
        try {
            while (reader.next()) {
                ++row;
                writer.setRow(reader.getRow());
                String orginalContig = reader.getString(format.getChromosome());
                boolean ignore = false;
                if (reader.getString(format.getPosition()).isEmpty()) {
                    this.log("Warning: Row " + row + ": Position is empty. Ignore variant.");
                    ++this.ignored;
                    ignore = true;
                }
                int originalPosition = 0;
                if (!ignore) {
                    try {
                        originalPosition = reader.getInteger(format.getPosition());
                    }
                    catch (NumberFormatException e) {
                        this.log("Warning: Row " + row + ": '" + reader.getString(format.getPosition()) + "' is an invalid position. Ignore variant.");
                        ++this.ignored;
                        ignore = true;
                    }
                }
                String effectAllele = reader.getString(format.getEffectAllele());
                String otherAllele = reader.getString(format.getOtherAllele());
                if (!ignore) {
                    int stop;
                    int start;
                    Interval source;
                    Interval target;
                    String contig = "";
                    String newContig = "";
                    if (orginalContig.equals("chr23")) {
                        orginalContig = "chrX";
                    }
                    if (orginalContig.equals("23")) {
                        orginalContig = "X";
                    }
                    if (orginalContig.startsWith("chr")) {
                        contig = orginalContig;
                        newContig = orginalContig.replaceAll("chr", "");
                    } else {
                        contig = "chr" + orginalContig;
                        newContig = orginalContig;
                    }
                    String id = orginalContig + ":" + originalPosition;
                    int length = otherAllele.length();
                    if (length == 0) {
                        length = 1;
                    }
                    if ((target = liftOver.liftOver(source = new Interval(contig, start = originalPosition, stop = originalPosition + length - 1, false, id))) != null) {
                        if (source.getContig().equals(target.getContig())) {
                            if (length != target.length()) {
                                this.log(id + "\tLiftOver\tINDEL_STRADDLES_TWO_INTERVALS. SNP removed.");
                                ignore = true;
                                ++this.failed;
                            } else {
                                if (target.isNegativeStrand()) {
                                    writer.setString(format.getEffectAllele(), LiftOverScoreTask.flip(effectAllele));
                                    writer.setString(format.getOtherAllele(), LiftOverScoreTask.flip(otherAllele));
                                }
                                if (otherAllele != null && effectAllele != null) {
                                    writer.setString(format.getChromosome(), newContig);
                                    writer.setInteger(format.getPosition(), target.getStart());
                                    ++this.resolved;
                                } else {
                                    this.log(id + "\tLiftOver\tIndel on negative strand. SNP removed.");
                                    ignore = true;
                                    ++this.failed;
                                }
                            }
                        } else {
                            this.log(id + "\tLiftOver\tOn different chromosome after LiftOver. SNP removed.");
                            ignore = true;
                            ++this.failed;
                        }
                    } else {
                        this.log(id + "\tLiftOver\tLiftOver failed. SNP removed.");
                        ignore = true;
                        ++this.failed;
                    }
                }
                if (ignore) {
                    writer.setString(format.getChromosome(), "");
                    writer.setString(format.getPosition(), "");
                    writer.setString(format.getEffectAllele(), "");
                    writer.setString(format.getEffectWeight(), "");
                    writer.setString(format.getOtherAllele(), "");
                }
                writer.next();
                ++this.total;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            writer.close();
            reader.close();
        }
    }

    protected static String flip(String allele) {
        String flippedAllele = "";
        for (int i = 0; i < allele.length(); ++i) {
            Character flipped = ALLELE_SWITCHES.get(Character.valueOf(allele.charAt(i)));
            flippedAllele = flippedAllele + flipped;
        }
        return flippedAllele;
    }

    protected void log(String message) {
        if (VERBOSE) {
            System.out.println(message);
        }
    }

    public int getTotal() {
        return this.total;
    }

    public int getResolved() {
        return this.resolved;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getIgnored() {
        return this.ignored;
    }

    static {
        ALLELE_SWITCHES.put(Character.valueOf('A'), Character.valueOf('T'));
        ALLELE_SWITCHES.put(Character.valueOf('T'), Character.valueOf('A'));
        ALLELE_SWITCHES.put(Character.valueOf('G'), Character.valueOf('C'));
        ALLELE_SWITCHES.put(Character.valueOf('C'), Character.valueOf('G'));
    }
}

