/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.tasks;

import genepi.io.table.writer.CsvTableWriter;
import genepi.riskscore.io.OutputFileReader;
import genepi.riskscore.tasks.ApplyScoreTask;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;

public class MergeScoreTask
implements ITaskRunnable {
    private String output;
    private List<String> inputs = new Vector<String>();

    public void setOutput(String output) {
        this.output = output;
    }

    public void setInputs(String ... filenames) throws IOException {
        for (String filename : filenames) {
            if (!new File(filename).exists()) continue;
            this.inputs.add(filename);
        }
    }

    public void setInputs(List<ApplyScoreTask> tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            ApplyScoreTask task = tasks.get(i);
            String filename = task.getOutput();
            if (!new File(filename).exists()) continue;
            this.inputs.add(filename);
        }
    }

    public void run(ITaskMonitor monitor) throws Exception {
        monitor.begin("Merge score files");
        assert (this.output != null);
        if (this.inputs.isEmpty()) {
            throw new Exception("No chunks found to merge.");
        }
        OutputFileReader[] files = new OutputFileReader[this.inputs.size()];
        for (int i = 0; i < this.inputs.size(); ++i) {
            files[i] = new OutputFileReader(this.inputs.get(i));
        }
        List<String> scores = files[0].getScores();
        String[] columns = new String[scores.size() + 1];
        columns[0] = "sample";
        for (int i = 0; i < scores.size(); ++i) {
            columns[i + 1] = scores.get(i);
        }
        CsvTableWriter writer = new CsvTableWriter(this.output, ',');
        writer.setColumns(columns);
        while (files[0].next()) {
            int i;
            double[] values = files[0].getValues();
            for (i = 1; i < files.length; ++i) {
                if (!files[i].next()) {
                    throw new Exception("Not all vcf files have the same number of samples.");
                }
                double[] data = files[i].getValues();
                for (int j = 0; j < data.length; ++j) {
                    int n = j;
                    values[n] = values[n] + data[j];
                }
            }
            writer.setString("sample", files[0].getSample());
            for (i = 0; i < scores.size(); ++i) {
                writer.setDouble(scores.get(i), values[i]);
            }
            writer.next();
        }
        for (int i = 1; i < files.length; ++i) {
            if (files[i].next()) {
                throw new Exception("Not all vcf files have the same number of samples.");
            }
            files[i].close();
        }
        writer.close();
        monitor.done();
        this.inputs = null;
    }
}

